"use client";
import React, { useState } from "react";
import { FaPlay, FaTimes } from "react-icons/fa";
import ReactPlayer from "react-player";
import Image from "next/image";

const VideoTour = () => {
  const [showModal, setShowModal] = useState(false);

  return (
    <section>
      <div className="container">
        <div className="video-tour-container">
          <Image
            width={700}
            height={600}
            src="/images/gallery/exte/2.jpg"
            alt="Resort View"
          />

          {/* Start Video Button */}
          <div className="video-overlay" onClick={() => setShowModal(true)}>
            <span>
              Start <br />
              Video
              <br /> Tour
            </span>
            <div className="play-icon">
              <FaPlay size={50} color="#000" />
            </div>
          </div>

          {/* Video Modal */}
          {showModal && (
            <div className="video-modal" onClick={() => setShowModal(false)}>
              <div
                className="modal-contents"
                onClick={(e) => e.stopPropagation()}
              >
                <FaTimes
                  className="close-btn"
                  onClick={() => setShowModal(false)}
                />
                <ReactPlayer
                  url="https://youtu.be/UNeEDq30tmo" // Replace with your video
                  controls
                  playing
                  width="100%"
                  height="100%"
                />
              </div>
            </div>
          )}
        </div>
      </div>
    </section>
  );
};

export default VideoTour;
